<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/expo/css/style.css">
    <link rel="shortcut icon" href="/expo/img/logo.svg" type="image/svg">
    <link href="https://fonts.googleapis.com/css2?family=Courier+Prime:wght@400;700&display=swap" rel="stylesheet">
    <title>Expo-Elizebeth_Friedman Stats</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
<header>
    <nav>
        <div class="link_group">
            <a href="https://nkodiadiabate.butmmi.o2switch.site/expo/index.php?action=deconn">Déconnexion</a>
            <a href="https://nkodiadiabate.butmmi.o2switch.site/expo/index.php?action=user">utilisateurs</a>
            <a href="https://nkodiadiabate.butmmi.o2switch.site/expo/index.php?action=ticket">tickets</a>
        </div>
        <img src="/expo/img/logo.svg" alt="logo">
        <button><a href="english/index.php?action=stat">EN</a></button>
    </nav>
</header>

<main>
<h1>📊 Page Statistiques</h1>

<p>La page Statistiques présente un aperçu des performances du site de réservation, incluant le total des réservations, la fréquentation des expositions et les tendances des jours et horaires populaires.</p>

<div class="stat-graph">
    <div class="graph-container">
        <h3>Nombre total d'utilisateur et des tickets de réservations</h3>
        <canvas id="chartTotal" width="500" height="500"></canvas>
    </div>

    <div class="graph-container">
        <h3>Nombre total de tickets par date de réservation</h3>
        <canvas id="chartDates" width="100" height="100"></canvas>
    </div>

    <div class="graph-container">
        <h3>Nombre total de tickets par crénaux horaire de réservation</h3>
        <canvas id="chartHeures" width="100" height="100"></canvas>
    </div>
</div>
</main>

<?php
$pdo = new PDO('mysql:host=localhost;dbname=nkodiadiabate_casser_les_codes', 'nkodiadiabate', 'bd4FEtDMixSDgKm');

// Comptage global
$stmt = $pdo->query("SELECT COUNT(*) AS count FROM ticket");
$ticket_count = $stmt->fetch(PDO::FETCH_ASSOC)['count'];

$stmt = $pdo->query("SELECT COUNT(*) AS count FROM user");
$user_count = $stmt->fetch(PDO::FETCH_ASSOC)['count'];

// Comptage par date
$stmt = $pdo->query("SELECT date, COUNT(*) AS count FROM ticket GROUP BY date");
$date_counts = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Comptage par heure
$stmt = $pdo->query("SELECT heure, COUNT(*) AS count FROM ticket GROUP BY heure");
$heure_counts = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<script>
    const ctxTotal = document.getElementById('chartTotal').getContext('2d');
    new Chart(ctxTotal, {
        type: 'bar',
        data: {
            labels: ['Tickets de Réservation', 'Comptes Utilisateurs'],
            datasets: [{
                label: 'Nombre total',
                data: [<?= $ticket_count ?>, <?= $user_count ?>],
                backgroundColor: ['#3498db', '#2ecc71']
            }]
        },
        options: {
            responsive: true,
            plugins: { legend: { display: true } }
        }
    });

    const ctxDates = document.getElementById('chartDates').getContext('2d');
    new Chart(ctxDates, {
        type: 'line',
        data: {
            labels: <?= json_encode(array_column($date_counts, 'date')) ?>,
            datasets: [{
                label: 'Réservations par Date',
                data: <?= json_encode(array_column($date_counts, 'count')) ?>,
                backgroundColor: '#e74c3c'
            }]
        },
        options: {
            responsive: true,
            plugins: { legend: { display: true } }
        }
    });

    const ctxHeures = document.getElementById('chartHeures').getContext('2d');
    new Chart(ctxHeures, {
        type: 'pie',
        data: {
            labels: <?= json_encode(array_column($heure_counts, 'heure')) ?>,
            datasets: [{
                label: 'Réservations par Heure',
                data: <?= json_encode(array_column($heure_counts, 'count')) ?>,
                backgroundColor: ['#8e44ad', '#2ecc71', '#3498db', '#e67e22', '#e74c3c']
            }]
        },
        options: {
            responsive: true,
            plugins: { legend: { display: true } }
        }
    });
</script>

</body>
</html>
