<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/expo/css/style.css">
    <link rel="shortcut icon" href="/expo/img/logo.svg" type="image/svg">
    <title>Expo-Elizebeth_Friedman BackOffice-users</title>
</head>
<?php
if (!isset($_SESSION['login']) || $_SESSION['user_id'] != 1) {
    echo "You cannot access this page because you are not an administrator.";
    exit;
}
?>
<body>
<header>
    <nav>
        <div class="link_group">
            <a href="https://nkodiadiabate.butmmi.o2switch.site/expo/english/index.php?action=logout">Log out</a>
            <a href="https://nkodiadiabate.butmmi.o2switch.site/expo/english/index.php?action=ticket">Tickets</a>
            <a href="https://nkodiadiabate.butmmi.o2switch.site/expo/english/index.php?action=stat">Statistics</a>
        </div>
        <img src="../img/logo.svg" alt="">
        <button><a href="../index.php?action=user">FR</a></button>
    </nav>
</header>
<main>
    <h1>👥 Users Page</h1>

    <p>The Users Page lists all registered members on the platform. It allows viewing profiles, managing user information, and tracking their reservation history.</p>

    <table width="100%" border="1" cellspacing="0" cellpadding="8" align="center" style="border-collapse: collapse;">
                <tr>
                    <th>ID</th>
                    <th>Last Name</th>
                    <th>First Name</th>
                    <th>Email</th>
                    <th>Delete</th>
                </tr>
<?php
$ch = curl_init("https://nkodiadiabate.butmmi.o2switch.site/expo/api/index.php?action=user");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

$data = json_decode($response, true) ?? [];

if (!isset($data['status'])) {
    echo "<p>Erreur : Réponse invalide du serveur</p>";
    exit;
}

if ($data['status'] === 200 && isset($data['users'])) {
    foreach ($data['users'] as $user) {
            echo '
                <tr align="center">
                    <td>' . $user['id'] . '</td>
                    <td>' . $user['nom'] . '</td>
                    <td>' . $user['prenom'] . '</td>
                    <td>' . $user['email'] . '</td>
                    <td>
                        <button class="bouton" onclick="deleteUser(' . $user['id'] . ')" style="cursor: pointer;">Delete</button>
                    </td>
                </tr>
';
    }
} else {
    echo "<p>Erreur : {$data['message']}</p>";
}
?>
</table>
</main>
<script>
    function deleteUser(id) {
    fetch(`https://nkodiadiabate.butmmi.o2switch.site/expo/api/index.php?action=supr_user&id=${id}`, {
        method: "DELETE"
    })
    .then(response => response.json())
    .then(data => {
        alert(data.message);
        location.reload();
    })
    .catch(error => console.error("Erreur :", error));
}
</script>
</body>
</html>
