<?php
require_once '../autoload.php';

$personnages = $monManager->getAllPersonnages();
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/jpg" href="../img/logo.png">
    <link rel="stylesheet" href="../styles/start.css">
    <title>Sélection de personnage</title>
</head>
<body>
    <h1>Ecran de sélection des personnages</h1>
    <div class='music-control'>
    <audio src="../music/Aria_of_the_soul.mp3" id='audio' loop></audio>
        <h3>Musique de l'écran de sélection</h3>
        <a href="javascript:void(0)" onclick=changeState(0) class='btn'>Play</a>
        <a href="javascript:void(0)" onclick=changeState(1) class='btn'>Pause</a>
        <a href="javascript:void(0)" onclick=changeState(2) class='btn active'>Stop</a>
    </div>
    <form action='index.php?action=fight' method='POST'>
    <div class="perso_container">
            <div class='persona'>
                <h2>Choisis ta persona</h2>
                    <label for="personnage1">Personnage 1:</label>
                    <select name="personnage1" id="personnage1">
                        <?php foreach ($personnages as $perso){ ?>
                            <option value="<?= $perso->getId() ?>" data-img="<?= $perso->getImage() ?>">
                                <?= htmlspecialchars($perso->getName()) ?>
                            </option>
                        <?php } ?>
                    </select>
                <img id="img_personnage1" src="../img/<?= $personnages[0]->getImage() ?>" alt="Image du personnage 1">
            </div>
            <img src="../img/VS.png" alt="versus" class='vs'>
            <div class='persona'>
                <h2>Choisi la persona de ton adversaire</h2>
                <label for="personnage2">Personnage 2:</label>
                <select name="personnage2" id="personnage2">
                    <?php foreach ($personnages as $perso){ ?>
                        <option value="<?= $perso->getId() ?>" data-img="<?= $perso->getImage()?>">
                            <?= htmlspecialchars($perso->getName()) ?>
                        </option>
                    <?php } ?>
                </select>
                <img id="img_personnage2" src="../img/<?= $personnages[0]->getImage() ?>" alt="Image du personnage 2">
            </div>
        </div>
        <input id="btn_start" type="submit" value="Commencer le combat">
    </form>

    <br><br>
        <a href="index.php?action=back" class='btn'>Liste des personnages</a>
    <br><br>

<script src='script.js'></script>
<script>
    //controles de la musique
    function changeState(x){
    let btns = document.querySelectorAll(".btn");
    let audio = document.querySelector("#audio");
    for(let i = 0; i < btns.length; i++){
        btns[i].classList.remove("active");
    }
    btns[x].classList.add("active");

    if(x == 0){
        audio.play();
    }
    if(x == 1){
        audio.pause();
    }
    if(x == 2){
        audio.pause();
        audio.currentTime = 0;
    }
}
</script>
</body>
</html>
