<?php
require_once '../autoload.php';
session_start();

$action = $_GET['action'] ?? 'accueil';

switch ($action) {
    //accueil
    case 'accueil':
        require 'accueil.php';
        break;

    //selection des personnages
    case 'start':
        require 'start.php';
        break;

    // Back-office du site 
    case 'back':
        require 'back.php';
        break; 


    //Scène de combat 
    case 'fight':
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            
             if (!isset($_POST['personnage1']) || !isset($_POST['personnage2'])) {
                $error = "Vous devez choisir deux personnages pour commencer le combat.";
                include 'view/start.php';
                exit;
            }

            $perso1 = $monManager->getOnePersonnageById($_POST['personnage1']);
            $perso2 = $monManager->getOnePersonnageById($_POST['personnage2']);
            
            if ($perso1 == $perso2) {
                $error = "Vous ne pouvez pas choisir le même personnage pour les deux combattants.";
                include 'view/start.php';
                exit;
            }

            
            $_SESSION['personnage1'] = $perso1;
            $_SESSION['personnage2'] = $perso2;

            header('Location: index.php?action=fight');
            exit;
        } else if ($_SERVER['REQUEST_METHOD'] == 'GET') {
            
            if (!isset($_SESSION['personnage1']) || !isset($_SESSION['personnage2'])) {
                $error = "Les valeurs de session ne sont pas définies.";
                include 'view/start.php';
                exit;
            }}

        require 'fight_screen.php';
        break;
        
    // Modifier un personnage
    case 'modif':
        if (isset($_POST['id'])) {
            $perso = new Personnage([
                'id' => $_POST['id'],
                'name' => $_POST['name'],
                'hp' => $_POST['hp'],
                'atk' => $_POST['atk'],
                'def' => $_POST['def'],
            ]);
            $monManager->modifyPersonnage($perso);
        }
        header('Location: index.php?action=back');
        exit();
        break;


    // Ajouter un personnage 
    case 'add':
        if (isset($_POST['addPerso'])) {
    
            if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
                $target_dir = "../img/";
                $file_name = basename($_FILES["image"]["name"]);
                $target_file = $target_dir . $file_name;
                $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
    
                $check = getimagesize($_FILES["image"]["tmp_name"]);
                if ($check === false) {
                    die("Le fichier n'est pas une image valide.");
                }
    
                if (!move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
                    die("Erreur lors de l'upload de l'image.");
                }
    
                $_POST['image'] = $file_name;
            } else {
                $_POST['image'] = "default.jpg";
            }
    
            $monManager->addPersonnage(new Personnage($_POST));
    
            header("Location: index.php?action=back");
            exit();
        }
        break;
    


    //Supprimer un personnage 
    case 'suppr':
        $id = $_GET['id'];
        $monManager->deletePersonnage($id);
        header('Location: index.php?action=back');
        break;


    // Attaque
    case 'attack':

        if (isset($_SESSION['personnage1'], $_SESSION['personnage2'])) {
            $perso1 = $_SESSION['personnage1'];
            $perso2 = $_SESSION['personnage2'];
    

            $perso1->attack($perso2);
            $perso2->attack($perso1);
    
            if ($perso1->mort()) {
                $_SESSION['gagnant'] = $perso2->getName();
                $_SESSION['gagnant_img'] = $perso2->getImage();
                header('Location: index.php?action=end');
                exit;
            }
    
            if ($perso2->mort()) {
                $_SESSION['gagnant'] = $perso1->getName();
                $_SESSION['gagnant_img'] = $perso1->getImage();
                header('Location: index.php?action=end');
                exit;
            }

            header('Location: index.php?action=fight');
            exit;
        } else {

            echo "Erreur : les personnages n'ont pas été correctement initialisés.";
            exit;
        }
        break;
    


    //buff d'attaque
    case 'buff_atk':
        $perso1= $_SESSION['personnage1'];

        $perso1->buff_atk();

        $_SESSION['personnage1'] = $perso1;
        header('Location: index.php?action=fight');
        break;


    //buff de défence
    case 'buff_def':
        $perso1= $_SESSION['personnage1'];
    
        $perso1->buff_def();
    
        $_SESSION['personnage1'] = $perso1;
        header('Location: index.php?action=fight');
        break;


    //debuff d'attaque
    case 'debuff_atk':
        $perso1= $_SESSION['personnage1'];
        $perso2= $_SESSION['personnage2'];

        $perso1->debuff_atk($perso2);

        $_SESSION['personnage1'] = $perso1;
        $_SESSION['personnage2'] = $perso2;

        header('Location: index.php?action=fight');
        break;


    //debuff de def
    case 'debuff_def':
        $perso1= $_SESSION['personnage1'];
        $perso2= $_SESSION['personnage2'];

        $perso1->debuff_def($perso2);

        $_SESSION['personnage1'] = $perso1;
        $_SESSION['personnage2'] = $perso2;

        header('Location: index.php?action=fight');
        break;

    //fin de combat 
    case 'end':
        require 'end.php';
    break;

    //fin de session
    case 'exit':
        session_destroy();
        header('Location: index.php?action=accueil');
        break;

}

?>
<script src='script.js'></script>