<?php 
class PersonnageManager {
    private $db;
    public function __construct($db) {
        $this->db = $db;
    }

    public function getAllPersonnages() :array {
        $requete = 'SELECT * FROM personnage ORDER BY name';
        $stmt = $this->db->query($requete);

        $personnages = [];

        while ($perso = $stmt->fetch(PDO::FETCH_ASSOC)) {
            
            $personnages[] = new Personnage($perso);
        }
        return $personnages;
    }

    public function getOnePersonnageById($id) :Personnage {
        $stmt = $this->db->prepare('SELECT * FROM personnage WHERE id = :id');
        $stmt->bindValue(':id', $id);
        $stmt->execute();
        $perso = $stmt->fetch(PDO::FETCH_ASSOC);
        return new Personnage($perso);
    }

    public function addPersonnage(Personnage $perso) {
        $requete = $this->db->prepare('INSERT INTO personnage (name, hp, atk, def, compteur_buff, decompte_buff, compteur_debuff, decompte_debuff, image) 
                                       VALUES (:name, :hp, :atk, :def, 0, 3, 0, 3, :image)');
    
        $requete->bindValue(':name', $perso->getName()); 
        $requete->bindValue(':hp', $perso->getHp());     
        $requete->bindValue(':atk', $perso->getAtk());    
        $requete->bindValue(':def', $perso->getDef());   
        $requete->bindValue(':image', $perso->getImage());   

        $requete->execute();
    }

    public function modifyPersonnage(Personnage $perso) {
        $requete = $this->db->prepare('UPDATE personnage SET name = :name, hp = :hp, atk = :atk, def = :def WHERE id = :id');

        $requete->bindValue(':id', $perso->getId());
        $requete->bindValue(':name', $perso->getName()); 
        $requete->bindValue(':hp', $perso->getHp());     
        $requete->bindValue(':atk', $perso->getAtk());    
        $requete->bindValue(':def', $perso->getDef());   
        // $requete->bindValue(':image', $perso->getImage());   

        $requete->execute();
    }

    public function deletePersonnage($id) {
        $requete = $this->db->prepare('DELETE FROM personnage WHERE id = :id');
        $requete->bindParam(':id', $id, PDO::PARAM_INT);
        $requete->execute();
    }
}

?>